﻿using System;
using System.IO;
using System.Reflection;

namespace gov.va.med.VBECS.VistaLinkServer.Core
{
    [Serializable]
    public class RemoteRunner
    {
        public object LoadDll(string assemblyNameLocation, string fullTypeName, string methodName, object[] parameters)
        {
            //CR3557
            //load the assembly into bytes and load it
            var a = Assembly.LoadFrom(assemblyNameLocation);
            //find the type in the assembly
            var t = a.GetType(fullTypeName, true);
            //find the method "Run"
            var run = t.GetMethod(methodName);

            //run it (static method, no arguments)
            return run.Invoke(Activator.CreateInstance(t), parameters);
        }
    }
}
